-- ReaScript (Lua)
-- Mover la pista con foco una posición abajo,
-- mantener el foco en la nueva posición y verbalizar el número con OSARA

function MoveFocusedTrackDown()
  local track = reaper.GetSelectedTrack(0, 0)
  if not track then return end

  local idx = math.floor(reaper.GetMediaTrackInfo_Value(track, "IP_TRACKNUMBER")) - 1
  local totalTracks = reaper.CountTracks(0)
  if idx >= totalTracks - 1 then return end -- ya está en la última posición

  reaper.Undo_BeginBlock()
  reaper.PreventUIRefresh(1)

  -- Seleccionar solo esta pista
  reaper.SetOnlyTrackSelected(track)

  -- Reordenar: mover la pista seleccionada a la posición siguiente
  reaper.ReorderSelectedTracks(idx + 2, 0)
  -- Nota: se usa idx+2 porque ReorderSelectedTracks coloca la pista ANTES del índice dado

  -- Obtener la pista en la nueva posición y dejarla seleccionada (foco)
  local newTrack = reaper.GetTrack(0, idx + 1)
  if newTrack then
    reaper.SetOnlyTrackSelected(newTrack)

    -- Número humano (1-based), convertido a entero
    local newIdx = math.floor(reaper.GetMediaTrackInfo_Value(newTrack, "IP_TRACKNUMBER"))
    if reaper.osara_outputMessage then
      reaper.osara_outputMessage("Pista " .. tostring(newIdx))
    end
  end

  reaper.PreventUIRefresh(-1)
  reaper.Undo_EndBlock("Mover pista con foco abajo", -1)
end

MoveFocusedTrackDown()