-- ReaScript (Lua)
-- Mover la pista con foco una posición arriba,
-- mantener el foco en la nueva posición y verbalizar el número con OSARA

function MoveFocusedTrackUp()
  local track = reaper.GetSelectedTrack(0, 0)
  if not track then return end

  local idx = reaper.GetMediaTrackInfo_Value(track, "IP_TRACKNUMBER") - 1
  if idx <= 0 then return end -- ya está en la primera posición

  reaper.Undo_BeginBlock()
  reaper.PreventUIRefresh(1)

  -- Seleccionar solo esta pista
  reaper.SetOnlyTrackSelected(track)

  -- Reordenar: mover la pista seleccionada a la posición anterior
  reaper.ReorderSelectedTracks(idx - 1, 0)

  -- Obtener la pista en la nueva posición y dejarla seleccionada (foco)
  local newTrack = reaper.GetTrack(0, idx - 1)
  if newTrack then
    reaper.SetOnlyTrackSelected(newTrack)

    -- Número humano (1-based), convertido a entero
    local newIdx = math.floor(reaper.GetMediaTrackInfo_Value(newTrack, "IP_TRACKNUMBER"))
    -- Verbalizar con OSARA si está disponible
    if reaper.osara_outputMessage then
      reaper.osara_outputMessage("Pista " .. tostring(newIdx))
    end
  end

  reaper.PreventUIRefresh(-1)
  reaper.Undo_EndBlock("Mover pista con foco arriba", -1)
end

MoveFocusedTrackUp()